using System;
using System.Xml;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents VistALink close socket response 
	/// message as defined in VistALink protocol
	/// </summary>
    public sealed class VistALinkCloseSocketResponseMessage : VistALinkSimpleResponseMessage, ICloseConnectionResponceMessage
	{
		/// <summary>
		/// VistALink message response type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string ResponseType = "closeSocket";

		/// <summary>
		/// Constructor specifying minimal required VistALink 
		/// close socket response message parameters. 
		/// </summary>
		///<param name="responseStatus">Response status.</param>
		public VistALinkCloseSocketResponseMessage( ResponseStatus responseStatus ) : 
			base( ResponseType, responseStatus ){}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document.</param>
		public VistALinkCloseSocketResponseMessage( XmlDocument sourceDoc ) : 
			base( ResponseType, sourceDoc ){}
	}
}
